<?php
// /PayPal/webhook.php
require_once 'config.php';

$payload = @file_get_contents('php://input');
$event = json_decode($payload);
// Add webhook signature verification here for production security

// The user already CAPTURED the payment by clicking "Pay Now" on the PayPal page
// So we just need to listen for the confirmation event.
if ($event && $event->event_type == 'CHECKOUT.ORDER.CAPTURED') {
    $resource = $event->resource;
    
    $customId = $resource->purchase_units[0]->custom_id;
    $parts = explode('|', $customId, 2);
    $systemUrl = base64_decode($parts[0]);
    $invoiceId = $parts[1] ?? 0;
    
    $capture = $resource->purchase_units[0]->payments->captures[0];
    $transactionId = $capture->id; 
    $paymentAmount = $capture->amount->value;

    if ($invoiceId && filter_var($systemUrl, FILTER_VALIDATE_URL)) {
        
        $callbackUrl = rtrim($systemUrl, '/') . '/modules/gateways/callback/rueezpaypal.php';
        $callbackData = [
            'invoiceid' => $invoiceId, 'transid' => $transactionId,
            'amount' => $paymentAmount, 'status' => 'success',
        ];
        
        $ch = curl_init($callbackUrl);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($callbackData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_exec($ch); curl_close($ch);
    }
}
http_response_code(200);