<?php
// /PayPal/payment.php
require_once 'config.php';
use PayPalCheckoutSdk\Orders\OrdersCreateRequest;

$invoiceId = filter_input(INPUT_POST, 'invoiceid', FILTER_VALIDATE_INT, ['options' => ['min_range' => 1]]);
$systemUrl = normalizeWhmcsUrl((string)($_POST['systemurl'] ?? ''));
$currency = strtoupper(trim((string)($_POST['currency'] ?? 'USD')));
$amountRaw = $_POST['amount'] ?? null;
$amountVal = is_numeric($amountRaw) ? (float)$amountRaw : 0.0;
$invoiceNumber = trim((string)($_POST['invoice_number'] ?? ''));
if ($invoiceNumber === '') {
    $invoiceNumber = (string)$invoiceId;
}
$invoiceNumber = preg_replace('/[^A-Za-z0-9\-_#]/', '', $invoiceNumber);
if ($invoiceNumber === '') {
    $invoiceNumber = (string)$invoiceId;
}
$sourceCode = getWhmcsSourceCode($systemUrl);

if (
    !$invoiceId ||
    $systemUrl === '' ||
    !isAuthorizedWhmcsUrl($systemUrl) ||
    $sourceCode === '' ||
    $amountVal <= 0 ||
    !preg_match('/^[A-Z]{3}$/', $currency)
) {
    die('Error: Unauthorized request.');
}

// Store data in session for the next step
$_SESSION['invoice_id_rueez'] = (int)$invoiceId;
$_SESSION['system_url_rueez'] = $systemUrl;

$client = getPayPalClient();
$request = new OrdersCreateRequest();
$request->prefer('return=representation');
$request->body = [
    'intent' => 'CAPTURE', // It is still a capture intent
    'purchase_units' => [[
        'description' => 'Rueez ' . $invoiceNumber,
        'custom_id' => $sourceCode . '|' . $invoiceId,
        'amount' => ['currency_code' => $currency, 'value' => number_format($amountVal, 2, '.', '')],
    ]],
    'application_context' => [
        'shipping_preference' => 'NO_SHIPPING',
        'user_action' => 'PAY_NOW',
        'brand_name' => 'Rueez Payments',
        // CRITICAL CHANGE: We redirect to a new 'capture.php' page
        'return_url' => APP_BASE_URL . '/PayPal/capture.php',
        'cancel_url' => APP_BASE_URL . '/PayPal/failed.php'
    ]
];
try {
    $response = $client->execute($request);
    $_SESSION['paypal_order_id'] = $response->result->id; // Save Order ID for capture
    foreach ($response->result->links as $link) {
        if ($link->rel === 'approve') {
            header('Location: ' . $link->href);
            exit();
        }
    }
} catch (Exception $e) { die("Could not create PayPal order. Please check logs."); }
