<?php
// /PayPal/config.php (FINAL LIVE VERSION)

$displayErrors = getenv('APP_DEBUG') === '1';
ini_set('display_errors', $displayErrors ? '1' : '0');
error_reporting(E_ALL);

if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

require __DIR__ . '/vendor/autoload.php';

use PayPalCheckoutSdk\Core\PayPalHttpClient;
use PayPalCheckoutSdk\Core\SandboxEnvironment;
use PayPalCheckoutSdk\Core\ProductionEnvironment;

define('APP_BASE_URL', rtrim(getenv('APP_BASE_URL') ?: 'https://pay.arpixia.com', '/'));
define('CALLBACK_SHARED_SECRET', getenv('CALLBACK_SHARED_SECRET') ?: 'aAfQ8vLk23QdR7mN6zZx1BwP5uTn4YhJ9sKc2VeM0rHp8GfD3tXw6CbL1yNm7RqZ');

// =========================================================
// ====== THIS IS THE ONLY LINE YOU NEED TO CHANGE LATER ====
//
//          Set to 'false' to process REAL money.
//      Set back to 'true' to use the sandbox for testing.
//
// =========================================================
define('PAYPAL_SANDBOX', false);

// --- LIVE (REAL MONEY) CREDENTIALS ---
// I have put your live keys here.
define('PAYPAL_LIVE_CLIENT_ID', getenv('PAYPAL_LIVE_CLIENT_ID') ?: 'AUTy50kU0ohfhZBwDsQdJ-IAiegr1eZF4E_RZVBeb-sya4gkkxZACCBgSX3PM9O8p2IXWpsNrFQXCDZp');
define('PAYPAL_LIVE_SECRET', getenv('PAYPAL_LIVE_SECRET') ?: 'EJAGR5bOHetIvXGB5GMEVvB0q4Mlu2yDHv9WKnLwiaj-vaBGjf_dNv0LMS22WUZSgvUC992QgAnhGbHB');
define('PAYPAL_LIVE_WEBHOOK_ID', getenv('PAYPAL_LIVE_WEBHOOK_ID') ?: '0G5782648G2707345');

// --- SANDBOX (TESTING) CREDENTIALS ---
// These are kept here in case you ever need to switch back to testing.
define('PAYPAL_SANDBOX_CLIENT_ID', getenv('PAYPAL_SANDBOX_CLIENT_ID') ?: 'AcotWCWbNejz7F5fBLO3YsVeCTEIfs-Tv0OMacXAzKTBv9NErM-pLp8FY0SWxPjEgo7GTbTD-5Va6C-p');
define('PAYPAL_SANDBOX_SECRET', getenv('PAYPAL_SANDBOX_SECRET') ?: 'EAW4NH1u3Gsqhl2Yady9ZDMyhFda-atYczTSc10iwB52x-yRZqzOyaH6Eyg7ng9OAWO4oqfcz5kVNVe2');
define('PAYPAL_SANDBOX_WEBHOOK_ID', getenv('PAYPAL_SANDBOX_WEBHOOK_ID') ?: '58R85716DX008144T');
define('PAYPAL_WEBHOOK_ID', getenv('PAYPAL_WEBHOOK_ID') ?: (PAYPAL_SANDBOX ? PAYPAL_SANDBOX_WEBHOOK_ID : PAYPAL_LIVE_WEBHOOK_ID));

// --- AUTHORIZED SITES & CORE LOGIC ---
// (No changes needed below this line)
$authorizedWhmcsUrls = [
    'https://arpixia.com',
    'https://my.filesmaster.io',
    'https://my.papahosting.com',
    'https://panel.mdmhost.com',
    'https://pay.arpixia.com',
];

$authorizedWhmcsSources = [
    's1' => 'https://arpixia.com',
    's2' => 'https://my.filesmaster.io',
    's3' => 'https://my.papahosting.com',
    's4' => 'https://panel.mdmhost.com',
    's5' => 'https://pay.arpixia.com',
];

function normalizeWhmcsUrl(string $url): string {
    $url = trim($url);
    if ($url === '' || !filter_var($url, FILTER_VALIDATE_URL)) {
        return '';
    }

    $parts = parse_url($url);
    if (!$parts || empty($parts['scheme']) || empty($parts['host'])) {
        return '';
    }

    $scheme = strtolower($parts['scheme']);
    $host = strtolower($parts['host']);
    $port = isset($parts['port']) ? ':' . (int)$parts['port'] : '';

    return $scheme . '://' . $host . $port;
}

function isAuthorizedWhmcsUrl(string $url): bool {
    global $authorizedWhmcsUrls;

    $normalizedUrl = normalizeWhmcsUrl($url);
    if ($normalizedUrl === '') {
        return false;
    }

    static $normalizedAllowed = null;
    if ($normalizedAllowed === null) {
        $normalizedAllowed = array_values(array_filter(array_map('normalizeWhmcsUrl', $authorizedWhmcsUrls)));
    }

    return in_array($normalizedUrl, $normalizedAllowed, true);
}

function getDefaultWhmcsUrl(): string {
    global $authorizedWhmcsUrls;

    $defaultUrl = $authorizedWhmcsUrls[0] ?? APP_BASE_URL;
    $normalized = normalizeWhmcsUrl($defaultUrl);

    return $normalized !== '' ? $normalized : APP_BASE_URL;
}

function getWhmcsSourceCode(string $url): string {
    global $authorizedWhmcsSources;

    $normalizedUrl = normalizeWhmcsUrl($url);
    if ($normalizedUrl === '') {
        return '';
    }

    foreach ($authorizedWhmcsSources as $sourceCode => $sourceUrl) {
        if ($normalizedUrl === normalizeWhmcsUrl($sourceUrl)) {
            return $sourceCode;
        }
    }

    return '';
}

function getWhmcsUrlBySourceCode(string $sourceCode): string {
    global $authorizedWhmcsSources;

    $sourceCode = trim($sourceCode);
    if ($sourceCode === '' || !isset($authorizedWhmcsSources[$sourceCode])) {
        return '';
    }

    $normalized = normalizeWhmcsUrl($authorizedWhmcsSources[$sourceCode]);
    return $normalized !== '' ? $normalized : '';
}

function getPayPalClient() {
    if (PAYPAL_SANDBOX) {
        $env = new SandboxEnvironment(PAYPAL_SANDBOX_CLIENT_ID, PAYPAL_SANDBOX_SECRET);
    } else {
        $env = new ProductionEnvironment(PAYPAL_LIVE_CLIENT_ID, PAYPAL_LIVE_SECRET);
    }
    return new PayPalHttpClient($env);
}
