<?php
// /PayPal/capture.php (Polished Version)
require_once 'config.php';
use PayPalCheckoutSdk\Orders\OrdersCaptureRequest;

// --- Step 1: Show an immediate message to the user ---
echo '<!DOCTYPE html><html><head><title>Processing Payment</title><style>body{font-family:sans-serif; text-align:center; padding-top:80px;} h1{color:#333;}</style></head><body><h1>Processing your payment, please wait...</h1></body></html>';
@ob_flush(); @flush(); // Force the message to be sent to the browser immediately


// --- Step 2: Perform the Capture (backend logic) ---
$orderId = $_GET['token'] ?? null;
$payerId = $_GET['PayerID'] ?? null;
$finalUrl = rtrim($_SESSION['system_url_rueez'] ?? 'https://arpixia.com', '/') . '/viewinvoice.php?id=' . ($_SESSION['invoice_id_rueez'] ?? 0) . '&paymentfailed=true';

if (!$orderId || !$payerId || $orderId !== ($_SESSION['paypal_order_id'] ?? '')) {
    header("Location: " . $finalUrl); exit();
}

$client = getPayPalClient();
$request = new OrdersCaptureRequest($orderId);

try {
    $response = $client->execute($request);
    
    if ($response->statusCode == 201 && $response->result->status === 'COMPLETED') {
        $invoiceId = $_SESSION['invoice_id_rueez'];
        $systemUrl = $_SESSION['system_url_rueez'];
        
        $capture = $response->result->purchase_units[0]->payments->captures[0];
        $transactionId = $capture->id;
        $paymentAmount = floatval($capture->amount->value); // Ensure it's a number

        // --- NEW: FEE CALCULATION ---
        // This calculates (Amount * 4%) + 0.40
        $fee = ($paymentAmount * 0.04) + 0.40;

        // --- CONTACT WHMCS (now with the fee included) ---
        $callbackUrl = rtrim($systemUrl, '/') . '/modules/gateways/callback/rueezpaypal.php';
        $callbackData = [
            'invoiceid' => $invoiceId,
            'transid'   => $transactionId,
            'amount'    => $paymentAmount,
            'fee'       => number_format($fee, 2, '.', ''), // Send the fee
            'status'    => 'success',
        ];
        
        $ch = curl_init($callbackUrl);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($callbackData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); curl_setopt($ch, CURLOPT_TIMEOUT, 129);
        curl_exec($ch); curl_close($ch);
        
        $finalUrl = rtrim($systemUrl, '/') . '/viewinvoice.php?id=' . $invoiceId . '&paymentsuccess=true';
    }

} catch (Exception $e) {
    error_log("Capture Error: " . $e->getMessage());
}

// --- Step 3: Use JavaScript for a smooth final redirect ---
session_unset();
echo "<script>window.location.href = '{$finalUrl}';</script>";
exit();